/*! \file 
 * X-Forge Core <br>
 * Copyright 2000-2003 Fathammer Ltd
 * 
 * \brief CPU info for ARM processors
 * 
 * $Id: XFcCPUInfoARM.h,v 1.6 2003/08/12 13:33:47 lars Exp $
 * $Date: 2003/08/12 13:33:47 $
 * $Revision: 1.6 $
 */

#ifndef XFC_CORE_XFCCPUINFOARM_H_INCLUDED
#define XFC_CORE_XFCCPUINFOARM_H_INCLUDED


enum XFCCPUINFO_ARM_IMPLEMENTORS
{
    XFCCPUINFO_ARM_IMPLEMENTOR_UNDEFINED = -1,
    XFCCPUINFO_ARM_IMPLEMENTOR_ARM,
    XFCCPUINFO_ARM_IMPLEMENTOR_DEC,
    XFCCPUINFO_ARM_IMPLEMENTOR_INTEL
};


/*
enum XFCCPUINFO_ARM_VARIANTS
{
    XFCCPUINFO_ARM_VARIANT_UNDEFINED = -1
};
*/


enum XFCCPUINFO_ARM_ARCHITECTURES
{
    XFCCPUINFO_ARM_ARCHITECTURE_UNDEFINED = -1,
    XFCCPUINFO_ARM_ARCHITECTURE_2,
    XFCCPUINFO_ARM_ARCHITECTURE_3,
    XFCCPUINFO_ARM_ARCHITECTURE_4,
    XFCCPUINFO_ARM_ARCHITECTURE_4T,
    XFCCPUINFO_ARM_ARCHITECTURE_5,
    XFCCPUINFO_ARM_ARCHITECTURE_5T,
    XFCCPUINFO_ARM_ARCHITECTURE_5TE
};


enum XFCCPUINFO_ARM_GENERATIONS
{
    XFCCPUINFO_ARM_GENERATION_UNDEFINED = -1,
    XFCCPUINFO_ARM_GENERATION_ARM3,
    XFCCPUINFO_ARM_GENERATION_ARM600,
    XFCCPUINFO_ARM_GENERATION_ARM610,
    XFCCPUINFO_ARM_GENERATION_ARM620,
    XFCCPUINFO_ARM_GENERATION_ARM7,
    XFCCPUINFO_ARM_GENERATION_SA1110,
    XFCCPUINFO_ARM_GENERATION_COTULLA_B1
};


enum XFCCPUINFO_ARM_REVISIONS
{
    XFCCPUINFO_ARM_REVISION_UNDEFINED = -1,
    XFCCPUINFO_ARM_REVISION_SA1110_A0 = 0x0,
    XFCCPUINFO_ARM_REVISION_SA1110_B0 = 0x4,
    XFCCPUINFO_ARM_REVISION_SA1110_B1 = 0x5,
    XFCCPUINFO_ARM_REVISION_SA1110_B2 = 0x6,
    XFCCPUINFO_ARM_REVISION_SA1110_B4 = 0x8,
};


class XFcCPUInfoARM
{
public:
    INT8 mImplementor;
//    INT8 mVariant;
    INT8 mArchitecture;
    INT8 mGeneration;
    INT8 mRevision;
    UINT32 mReg;

    XFcCPUInfoARM(UINT32 aReg);
};


#endif // !XFC_CORE_XFCCPUINFOARM_H_INCLUDED

